/*
 * @brief Secondary loader main application code
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "chip.h"
#include "sl_protocol.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/
#define LED_RED_ON  GPIOSetDir( 0, 12, 1 );\
					GPIOSetBitValue(0, 12, 0);
					
#define LED_RED_OFF GPIOSetDir( 0, 12, 1 );\
					GPIOSetBitValue(0, 12, 1);
					
#define LED_GREEN_ON  GPIOSetDir( 0, 0, 1 );\
					  GPIOSetBitValue(0, 0, 0);
					
#define LED_GREEN_OFF  GPIOSetDir( 0, 0, 1 );\
					   GPIOSetBitValue(0, 0, 1);
						 
#define LED_BLUE_ON  GPIOSetDir( 1, 15, 1 );\
					GPIOSetBitValue(1, 15, 0);	
#define LED_BLUE_OFF GPIOSetDir( 1, 15, 1 );\
					GPIOSetBitValue(1, 15, 1);
				


/*****************************************************************************
 * Private functions
 
 ****************************************************************************/
 

/*****************************************************************************
 * Public functions
 ****************************************************************************/

/**
 * @brief	main routine for Secondary loader
 * @return	Function should not exit
 */


extern SL_PINSETUP_T PINONLYCFGTABLEFLASH;

void KEY_Init()
{
	GPIOSetDir( 0, 13, 0 );
}

uint32_t Get_Key_Value()
{
	return GPIOGetPinValue(0, 13 );
}

void Delay()
{
	uint32_t i=0;
	for(i=0;i<100000;i++)
	{}
}

int main(void)
{

	SL_PINSETUP_T *psetup = (SL_PINSETUP_T*)&PINONLYCFGTABLEFLASH; 
					Enable_Periph_Clock(CLK_SWM);
					Enable_Periph_Clock(CLK_GPIO0);
					Enable_Periph_Clock(CLK_IOCON);
	GPIOInit();
	KEY_Init();
	

	while(1)
	{
		Delay();
		LED_BLUE_ON;
		Delay();
		LED_BLUE_OFF;
		/*If user key is pressed, jump to Secondary bootloader and wait for update*/
//		if(Get_Key_Value()==0)
//		{
//			Delay();
//			
//		#if APP1_ENABLE		
//			LED_RED_ON;
//		#else
//			LED_RED_ON;
//		#endif
//			/*jump to Secondary bootloade*/
//			bootSecondaryLoader(psetup);			
//		}
		
	}

	return 0;
}
